/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.client;

import com.gizmo.luggage.LuggageItem;
import com.gizmo.luggage.LuggageMenu;
import com.gizmo.luggage.Registries;
import com.gizmo.luggage.client.LuggageModel;
import com.gizmo.luggage.client.LuggageRenderer;
import com.gizmo.luggage.client.LuggageScreen;
import com.gizmo.luggage.client.LuggageTooltipComponent;
import com.gizmo.luggage.entity.LuggageEntity;
import com.gizmo.luggage.network.CallLuggagePetsPacket;
import com.gizmo.luggage.network.LuggageNetworkHandler;
import com.gizmo.luggage.network.OpenLuggageScreenPacket;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="luggage", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientEvents {
    public static final ModelLayerLocation LUGGAGE = new ModelLayerLocation(new ResourceLocation("luggage", "luggage"), "main");
    private static KeyMapping whistleKey;

    @SubscribeEvent
    public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(LUGGAGE, LuggageModel::create);
    }

    @SubscribeEvent
    public static void registerEntityRenderer(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)Registries.EntityRegistry.LUGGAGE.get(), LuggageRenderer::new);
    }

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        whistleKey = new KeyMapping("keybind.luggage.whistle", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 96, "key.categories.misc");
        ClientRegistry.registerKeyBinding((KeyMapping)ClientEvents.getWhistleKey());
        MinecraftForgeClient.registerTooltipComponentFactory(LuggageItem.Tooltip.class, LuggageTooltipComponent::new);
    }

    public static void handlePacket(OpenLuggageScreenPacket message) {
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(message.getEntityId());
        if (entity instanceof LuggageEntity) {
            LuggageEntity luggage = (LuggageEntity)entity;
            LocalPlayer localplayer = Minecraft.m_91087_().f_91074_;
            SimpleContainer simplecontainer = new SimpleContainer(luggage.hasExtendedInventory() ? 54 : 27);
            LuggageMenu menu = new LuggageMenu(message.getContainerId(), localplayer.m_150109_(), (Container)simplecontainer, luggage);
            localplayer.f_36096_ = menu;
            Minecraft.m_91087_().m_91152_((Screen)new LuggageScreen(menu, localplayer.m_150109_(), luggage));
        }
    }

    public static KeyMapping getWhistleKey() {
        return whistleKey;
    }

    @Mod.EventBusSubscriber(modid="luggage", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ClientForgeEvents {
        @SubscribeEvent
        public static void callTheCreatures(InputEvent.KeyInputEvent event) {
            if (ClientEvents.getWhistleKey().m_90859_() && event.getAction() != 2 && Minecraft.m_91087_().f_91074_ != null) {
                Minecraft.m_91087_().f_91074_.m_5496_(Registries.SoundRegistry.WHISTLE, 1.0f, 1.0f);
                LuggageNetworkHandler.CHANNEL.sendToServer((Object)new CallLuggagePetsPacket(Minecraft.m_91087_().f_91074_.m_142049_()));
            }
        }
    }
}

